

import java.util.Hashtable;

// Referenced classes of package duggelz.jape:
//            Field, Structure

public abstract class BasicStructure
    implements Structure
{

    public BasicStructure(Hashtable classFields)
    {
        fields = classFields;
    }

    public void chain(Structure nextStructure)
    {
        this.nextStructure = nextStructure;
    }

    public String get(String name)
    {
        Field field = (Field)fields.get(name);
        if(field == null)
        {
            if(nextStructure != null)
                return nextStructure.get(name);
            else
                return null;
        } else
        {
            return field.get(data);
        }
    }

    public int getInt(String name)
    {
        Field field = (Field)fields.get(name);
        if(field == null)
        {
            if(nextStructure != null)
                return nextStructure.getInt(name);
            else
                return 0;
        } else
        {
            return field.getInt(data);
        }
    }

    public void set(String name, String value)
    {
        Field field = (Field)fields.get(name);
        if(field != null)
            field.set(data, value);
        if(nextStructure != null)
            nextStructure.set(name, value);
    }

    public void setInt(String name, int value)
    {
        Field field = (Field)fields.get(name);
        if(field != null)
            field.setInt(data, value);
        if(nextStructure != null)
            nextStructure.setInt(name, value);
    }

    public Hashtable fields;
    public byte data[];
    public Structure nextStructure;
}